<?php
class Certificado {
    private $certificados;

    public function __construct($arquivo, $senha) {
        if (!file_exists($arquivo)) {
            throw new Exception("Erro: Certificado não encontrado.");
        }
        $conteudo = file_get_contents($arquivo);
        if (!$conteudo) {
            throw new Exception("Erro: O certificado não pode ser lido.");
        }
        if (!openssl_pkcs12_read($conteudo, $this->certificados, $senha)) {
            throw new Exception("Erro: Não foi possível carregar o certificado digital. Senha errada?");
        }
    }

    public function getPrivateKey() {
        return $this->certificados["pkey"];
    }

    public function getCertificate() {
        return $this->certificados["cert"];
    }

    public function getX509Certificate() {
        return preg_replace("/\r|\n/", "", trim(str_replace(
            ['-----BEGIN CERTIFICATE-----', '-----END CERTIFICATE-----'],
            '',
            $this->getCertificate()
        )));
    }
}